/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element.button;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.text.EnumColor;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiElement;
import mekanism.client.gui.element.button.MekanismButton;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.lib.Color;
import net.minecraft.network.chat.TextComponent;

public class BasicColorButton
extends MekanismButton {
    private final Supplier<EnumColor> colorSupplier;

    public static BasicColorButton toggle(IGuiWrapper gui, int x, int y, int size, EnumColor color, BooleanSupplier toggled, @Nullable Runnable onLeftClick, @Nullable GuiElement.IHoverable onHover) {
        return new BasicColorButton(gui, x, y, size, () -> toggled.getAsBoolean() ? color : null, onLeftClick, onLeftClick, onHover);
    }

    public static BasicColorButton renderActive(IGuiWrapper gui, int x, int y, int size, EnumColor color, @Nullable GuiElement.IHoverable onHover) {
        return new BasicColorButton(gui, x, y, size, () -> color, null, null, onHover);
    }

    public BasicColorButton(IGuiWrapper gui, int x, int y, int size, Supplier<EnumColor> color, @Nullable Runnable onLeftClick, @Nullable Runnable onRightClick, @Nullable GuiElement.IHoverable onHover) {
        super(gui, x, y, size, size, TextComponent.f_131282_, onLeftClick, onRightClick, onHover);
        this.colorSupplier = color;
    }

    @Override
    public void drawBackground(@Nonnull PoseStack matrix, int mouseX, int mouseY, float partialTicks) {
        boolean doColor;
        EnumColor color = this.getColor();
        boolean bl = doColor = color != null && color != EnumColor.GRAY;
        if (doColor) {
            Color c = Color.rgbi(color.getRgbCode()[0], color.getRgbCode()[1], color.getRgbCode()[2]);
            double[] hsv = c.hsvArray();
            hsv[1] = Math.max(0.0, hsv[1] - 0.25);
            hsv[2] = Math.min(1.0, hsv[2] + (double)0.4f);
            MekanismRenderer.color(Color.hsv(hsv[0], hsv[1], hsv[2]));
        } else {
            MekanismRenderer.resetColor();
        }
        super.drawBackground(matrix, mouseX, mouseY, partialTicks);
        if (doColor) {
            MekanismRenderer.resetColor();
        }
    }

    @Override
    protected boolean resetColorBeforeRender() {
        return false;
    }

    public EnumColor getColor() {
        return this.colorSupplier.get();
    }
}

